from infra.libs.monitoring_lib.docs_builder.alert.description import AlertDescription
from infra.libs.monitoring_lib.juggler.meta import Url, Urls
import infra.libs.monitoring_lib.docs_builder.basic.description as dsc
import infra.libs.monitoring_lib.docs_builder.basic.builder as bld


class EmptyAlertDescription(dsc.Description):
    def __init__(self, alert_name: str = "empty_alert"):
        super().__init__(alert_name)

    @property
    def markdown(self) -> str:
        return ":(((\n"


class EmptyPage(dsc.Page):
    def __init__(self, name: str = "empty_page"):
        super().__init__(name, "", {})

    def put_item(self, item):
        pass

    @property
    def markdown(self) -> str:
        return ""


def main():
    builder = bld.BasicDocsBuilder(
        'infra/libs/monitoring_lib/docs_builder/example',
        {
            dsc.VanillaPage('alerts', 'Описание алертов'): [AlertDescription],
            EmptyPage() : [],
        },
        path_in_docs="monitoring",
        docs_name="yp-dns"
    )
    description = AlertDescription(
        "sst_files_size_limit_usage",
        "Достигнут некоторый % от лимита на суммарный размер sst файлов в реплике",
        cases=AlertDescription.Cases(cases=[
            AlertDescription.Case(
                "Произошло уплотнение данных в реплике. " +
                "В этом случае будет краткий скачок размера (т.к. создались файлы на размер уплотнения) и откат до такого же или меньше значения (удалились старые).",
                "Безобидный момент т.к. не может выйти за общий лимит (но это не точно)"
            ),
            AlertDescription.Case("На самом деле, достигнут этот самый % от лимита", "Тогда надо либо поднять %, либо общий лимит")
        ]),
        urls=AlertDescription.Urls(urls=Urls([
            Url(title="msk_yp_dns", url="https://nanny.yandex-team.ru/ui/#/services/catalog/msk_yp_dns", meta={"type": "nanny"}),
            Url(title="man_yp_dns", url="https://nanny.yandex-team.ru/ui/#/services/catalog/man_yp_dns", meta={"type": "nanny", "skip_docs": None}),
            Url(title="sas_yp_dns", url="https://nanny.yandex-team.ru/ui/#/services/catalog/sas_yp_dns", meta={"type": "nanny"}),
            Url(title="nggyp", url="https://www.youtube.com/watch?v=dQw4w9WgXcQ", meta={"type": "you_tube"}),
            Url(title="https://docs.yandex-team.ru/yp-service-discovery/", url="https://docs.yandex-team.ru/yp-service-discovery/", meta={"type": "docs"}),
            Url(title="abc", url="https://abc.yandex-team.ru/services/service_discovery/"),
        ])),
        knowledgeable=AlertDescription.Knowledgeable(
            authors=["azuremint", "darkmint"],
            knowledgeable=["whitemint"],
        )
    )

    builder.put_item(description)
    builder.put_item_in_page(EmptyAlertDescription(), 'alerts')
    builder.build()
