from infra.libs.monitoring_lib.juggler.meta import Meta

from dataclasses import dataclass, field


@dataclass
class JugglerCheckOptionalArgs:
    meta: Meta = None
    other_args: dict = field(default_factory=lambda: None)

    @property
    def data(self) -> dict:
        if not self.meta:
            self.meta = Meta()
        result = {"meta": self.meta.data}
        if self.other_args:
            result |= self.other_args
        return result


class JugglerCheck:
    def __init__(self, host: str, service: str, optional_args: JugglerCheckOptionalArgs = None):
        self.host = host
        self.service = service
        if not optional_args:
            self.optional_args = JugglerCheckOptionalArgs()
        else:
            self.optional_args = optional_args

    @property
    def data(self) -> dict:
        data = {'host': self.host, 'service': self.service}
        data |= self.optional_args.data
        return data
