from infra.libs.monitoring_lib.juggler.meta import Url, Urls

from abc import ABCMeta, abstractmethod


class UrlGenerator(metaclass=ABCMeta):
    @abstractmethod
    def generate(self, project, object) -> Urls:
        pass


class JugglerUrlGenerator(UrlGenerator):
    def generate(self, project, juggler_check) -> Urls:
        juggler_project_id = project.api.juggler.options.project_id
        return Urls(
            urls=[
                Url(
                    title="Проверки",
                    url=f"https://juggler.yandex-team.ru/aggregate_checks/?project={juggler_project_id}" +
                        f"&query=service%3D{juggler_check.service}",
                    meta={"skip_juggler": None, "type": "juggler"}
                )
            ]
        )
