#pragma once

#include <library/cpp/logger/backend.h>
#include <util/generic/ptr.h>

namespace NInfra::NMultiLogBackend {

class TMultiLogBackend: public TLogBackend {
public:
    TMultiLogBackend(TVector<THolder<TLogBackend>> slaves);
    ~TMultiLogBackend() override;

    void WriteData(const TLogRecord& rec) override;
    void ReopenLog() override;

    void ReopenLogNoFlush() override;

    // return Max(QueueSize for slaves)
    size_t QueueSize() const override;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

}
