#pragma once

#include <util/datetime/base.h>
#include <util/generic/ptr.h>

namespace NInfra {

class ISensorBackend {
public:
    virtual ~ISensorBackend() = default;
};

using TSensorBackendPtr = TAtomicSharedPtr<ISensorBackend>;

template <typename T>
class IGaugeSensorBackend: public ISensorBackend {
public:
    virtual void Set(T x) = 0;
};

template <typename T>
using TGaugeSensorBackendPtr = TAtomicSharedPtr<IGaugeSensorBackend<T>>;

class ICounterSensorBackend: public ISensorBackend {
public:
    virtual void Add(ui64 x) = 0;

    void Inc() {
        Add(1);
    }
};

using TCounterSensorBackendPtr = TAtomicSharedPtr<ICounterSensorBackend>;

} // namespace NInfra
