#pragma once

#include "sensor.h"

// WARNING
// This macro creates a static variable that depends on Group and SensorName
// Therefore, they must be constants
#define STATIC_INFRA_RATE_SENSOR(Group, SensorName)                                                            \
    do {                                                                                                       \
        static const auto memGroup = Group;                                                                    \
        static const TStringBuf memSensorName = SensorName;                                                    \
        Y_ENSURE(                                                                                              \
            memGroup == Group && memSensorName == SensorName                                                   \
            , "Critical Error: you use static macros with non constant arguments. Use non static instead."     \
        );                                                                                                     \
        static ::NInfra::TRateSensor rateSensor(Group, SensorName);                                            \
        rateSensor.Inc();                                                                                      \
    } while (false);

// WARNING
// This macro creates a static variable that depends on Group and SensorName
// Therefore, they must be constants
#define STATIC_INFRA_RATE_SENSOR_X(Group, SensorName, x)                                                       \
    do {                                                                                                       \
        static const auto memGroup = Group;                                                                    \
        static const TStringBuf memSensorName = SensorName;                                                    \
        Y_ENSURE(                                                                                              \
            memGroup == Group && memSensorName == SensorName                                                   \
            , "Critical Error: you use static macros with non constant arguments. Use non static instead."     \
        );                                                                                                     \
        static ::NInfra::TRateSensor rateSensor(Group, SensorName);                                            \
        rateSensor.Add(x);                                                                                     \
    } while (false);

// WARNING
// This macro creates a static variable that depends on Group and SensorName
// Therefore, they must be constants
#define STATIC_INFRA_INT_GAUGE_SENSOR(Group, SensorName, sensor)                                               \
    do {                                                                                                       \
        static const auto memGroup = Group;                                                                    \
        static const TStringBuf memSensorName = SensorName;                                                    \
        Y_ENSURE(                                                                                              \
            memGroup == Group && memSensorName == SensorName                                                   \
            , "Critical Error: you use static macros with non constant arguments. Use non static instead."     \
        );                                                                                                     \
        static ::NInfra::TIntGaugeSensor gaugeSensor(Group, SensorName);                                       \
        gaugeSensor.Set(sensor);                                                                               \
    } while (false);

#define NON_STATIC_INFRA_RATE_SENSOR(Group, SensorName)                                                        \
    do {                                                                                                       \
        ::NInfra::TRateSensor rateSensor(Group, SensorName);                                                   \
        rateSensor.Inc();                                                                                      \
    } while (false);

#define NON_STATIC_INFRA_RATE_SENSOR_X(Group, SensorName, x)                                                   \
    do {                                                                                                       \
        ::NInfra::TRateSensor rateSensor(Group, SensorName);                                                   \
        rateSensor.Add(x);                                                                                     \
    } while (false);

#define NON_STATIC_INFRA_INT_GAUGE_SENSOR(Group, SensorName, sensor)                                           \
    do {                                                                                                       \
        ::NInfra::TIntGaugeSensor gaugeSensor(Group, SensorName);                                              \
        gaugeSensor.Set(sensor);                                                                               \
    } while (false);

#define NON_STATIC_INFRA_GAUGE_SENSOR(Group, SensorName, sensor)                                           \
    do {                                                                                                       \
        ::NInfra::TGaugeSensor gaugeSensor(Group, SensorName);                                              \
        gaugeSensor.Set(sensor);                                                                               \
    } while (false);
