#pragma once

#include <util/generic/hash.h>
#include <util/generic/string.h>

#include <library/cpp/monlib/metrics/labels.h>

namespace NInfra {

class TSensorGroup {
public:
    TSensorGroup(TStringBuf name)
        : Name_(name)
    {
    }

    TSensorGroup(const TSensorGroup& group, TStringBuf name)
        : Name_(ConcatenateNames(group.Name(), TString(name)))
        , Labels_(group.Labels_)
    {
    }

    TSensorGroup(const TSensorGroup& groupA, const TSensorGroup& groupB)
        : Name_(ConcatenateNames(groupA.Name(), groupB.Name()))
    {
    }

    void AddLabel(TStringBuf key, TStringBuf val) {
        Labels_.Add(key,  val);
    }

    TSensorGroup& AddLabels(const TVector<std::pair<TStringBuf, TStringBuf>>& labels) {
        for (const auto& [name, value] : labels) {
            Labels_.Add(name, value);
        }
        return *this;
    }

    const NMonitoring::TLabels& Labels() const {
        return Labels_;
    }

    const TString& Name() const {
        return Name_;
    }

    bool operator==(const TSensorGroup& other) const {
        return Name_ == other.Name_ && Labels_ == other.Labels_;
    }

private:
    TString ConcatenateNames(const TString& first, const TString& second) {
        if (first.empty()) {
            return second;
        }
        if (second.empty()) {
            return first;
        }

        return TStringBuilder() << first << "." << second;
    }

private:
    TString Name_;
    NMonitoring::TLabels Labels_;
};

} // namespace NInfra
