#include "sensor_registry.h"

#include <library/cpp/monlib/encode/json/json.h>
#include <library/cpp/monlib/encode/spack/spack_v1.h>

#include <util/generic/singleton.h>

namespace NInfra {

NMonitoring::TLabels NPrivate::CreateLabels(const TSensorGroup& group, TStringBuf name) {
    NMonitoring::TLabels labels = group.Labels();
    labels.Add("sensor", TSensorGroup{CommonGroup(), group.Name()}.Name() + "." + name);
    return labels;
}

TSensorGroup& NPrivate::CommonGroup() {
    static TSensorGroup commonGroup("");
    return commonGroup;
}

void SetSensorRegistryCommonGroup(const TSensorGroup& group) {
    NPrivate::CommonGroup() = group;
}

NMonitoring::IMetricEncoderPtr CreateEncoder(IOutputStream& outputStream, const ESensorsSerializationType type) {
    switch (type) {
        case ESensorsSerializationType::JSON: {
            return NMonitoring::EncoderJson(&outputStream);
        }
        case ESensorsSerializationType::SPACK_V1: {
            return NMonitoring::EncoderSpackV1(&outputStream, NMonitoring::ETimePrecision::SECONDS, NMonitoring::ECompression::LZ4);
        }
        default: {
            throw yexception() << "Unknown type for serialization";
        }
    }
}

void SensorRegistryPrint(IOutputStream& outputStream, const ESensorsSerializationType type) {
    NMonitoring::IMetricEncoderPtr encoder = CreateEncoder(outputStream, type);
    SensorRegistry().Accept(TInstant::Zero(), encoder.Get());
}

NMonitoring::TMetricRegistry& SensorRegistry() {
    return *Singleton<NMonitoring::TMetricRegistry>();
}

} // namespace NInfra
