#pragma once

#include "sensor_group.h"

#include <library/cpp/monlib/encode/encoder.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

namespace NInfra {

enum class ESensorsSerializationType {
    JSON = 1,
    SPACK_V1 = 2
};

namespace NPrivate {

TSensorGroup& CommonGroup();

NMonitoring::TLabels CreateLabels(const TSensorGroup& group, TStringBuf name);

} // namespace NPrivate

void SetSensorRegistryCommonGroup(const TSensorGroup& group);

NMonitoring::IMetricEncoderPtr CreateEncoder(IOutputStream& outputStream, const ESensorsSerializationType type = ESensorsSerializationType::JSON);

void SensorRegistryPrint(IOutputStream& outputStream, const ESensorsSerializationType type = ESensorsSerializationType::JSON);

NMonitoring::TMetricRegistry& SensorRegistry();

} // namespace NInfra
