#include "infra/libs/sensors/sensor.h"

#include <library/cpp/testing/unittest/registar.h>
#include <util/datetime/base.h>

//checking for NMonitoring::LinearHistogram

Y_UNIT_TEST_SUITE(HistogramCounterSensor) {
    Y_UNIT_TEST(NoExceptionChecker) {
        TStringBuf groupName = "testGroup";
        TStringBuf name = "testNameCounter";
        NInfra::TSensorGroup group(groupName);
        NMonitoring::IHistogramCollectorPtr collector(
            NMonitoring::LinearHistogram(
                NMonitoring::HISTOGRAM_MAX_BUCKETS_COUNT /*bucketsCount*/, 0.0 /*startValue*/, 1.0 /*bucketWidth*/));

        NInfra::THistogramCounterSensor histogram(group, name, std::move(collector));

        const ui64 numberOfAddingElements = 1024;
        const ui64 stepOfAdding = 50;

        for (ui64 i = 0, currentX = 0; i < numberOfAddingElements; ++i, currentX += stepOfAdding) {
            histogram.Add(currentX);
        }
    }

    Y_UNIT_TEST(CheckOfIncreasingValuesInHistogram) {
        TStringBuf groupName = "testGroup";
        TStringBuf name = "testNameCounter";
        NInfra::TSensorGroup group(groupName);
        NMonitoring::IHistogramCollectorPtr collector(
            NMonitoring::LinearHistogram(
                NMonitoring::HISTOGRAM_MAX_BUCKETS_COUNT /*bucketsCount*/, 0.0 /*startValue*/, 1.0 /*bucketWidth*/));

        NInfra::THistogramCounterSensor histogram(group, name, std::move(collector));

        const ui64 numberOfAddingElements = 1024;
        const ui64 stepOfAdding = 1;

        const NMonitoring::IHistogramSnapshotPtr startSnapshotPtr = histogram.TakeSnapshot();

        for (ui64 i = 0, currentX = 0; i < numberOfAddingElements; ++i, currentX += stepOfAdding) {
            histogram.Add(currentX);
        }

        const NMonitoring::IHistogramSnapshotPtr endSnapshotPtr = histogram.TakeSnapshot();

        for (ui64 i = 0; i < NMonitoring::HISTOGRAM_MAX_BUCKETS_COUNT; ++i) {
            UNIT_ASSERT(startSnapshotPtr->Value(i) < endSnapshotPtr->Value(i));
        }
    }

}

Y_UNIT_TEST_SUITE(HistogramRateSensor) {
    Y_UNIT_TEST(NoExceptionChecker) {
        TStringBuf groupName = "testGroup";
        TStringBuf name = "testNameRate";
        NInfra::TSensorGroup group(groupName);
        NMonitoring::IHistogramCollectorPtr collector(
            NMonitoring::LinearHistogram(
                NMonitoring::HISTOGRAM_MAX_BUCKETS_COUNT /*bucketsCount*/, 0.0 /*startValue*/, 1.0 /*bucketWidth*/));

        NInfra::THistogramRateSensor histogram(group, name, std::move(collector));

        const ui64 numberOfAddingElements = 1024;
        const ui64 stepOfAdding = 50;

        for (ui64 i = 0, currentX = 0; i < numberOfAddingElements; ++i, currentX += stepOfAdding) {
            histogram.Add(currentX);
        }
    }

    Y_UNIT_TEST(CheckOfIncreasingValuesInHistogram) {
        TStringBuf groupName = "testGroup";
        TStringBuf name = "testNameRate";
        NInfra::TSensorGroup group(groupName);
        NMonitoring::IHistogramCollectorPtr collector(
            NMonitoring::LinearHistogram(
                NMonitoring::HISTOGRAM_MAX_BUCKETS_COUNT /*bucketsCount*/, 0.0 /*startValue*/, 1.0 /*bucketWidth*/));

        NInfra::THistogramRateSensor histogram(group, name, std::move(collector));

        const ui64 numberOfAddingElements = 1024;
        const ui64 stepOfAdding = 1;

        const NMonitoring::IHistogramSnapshotPtr startSnapshotPtr = histogram.TakeSnapshot();

        for (ui64 i = 0, currentX = 0; i < numberOfAddingElements; ++i, currentX += stepOfAdding) {
            histogram.Add(currentX);
        }

        const NMonitoring::IHistogramSnapshotPtr endSnapshotPtr = histogram.TakeSnapshot();

        for (ui64 i = 0; i < NMonitoring::HISTOGRAM_MAX_BUCKETS_COUNT; ++i) {
            UNIT_ASSERT(startSnapshotPtr->Value(i) < endSnapshotPtr -> Value(i));
        }
    }
}
