#pragma once

#include "backend.h"
#include "sensor_group.h"

#include <library/cpp/monlib/metrics/metric.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

namespace NInfra {

namespace NPrivate {

NMonitoring::TLabels CreateLabels(const TSensorGroup& group, TStringBuf name);

} // namespace NPrivate

template <typename T>
class TSolomonGaugeBackend: public IGaugeSensorBackend<T> {
public:
    TSolomonGaugeBackend(const TSensorGroup& group, TStringBuf name, NMonitoring::TMetricRegistry& registry)
        : Impl_(registry.Gauge(NPrivate::CreateLabels(group, name)))
    {
    }

    void Set(T x) override {
        // XXX: Solomon can process only doubles now.
        Impl_->Set(static_cast<double>(x));
    }

private:
    NMonitoring::TGauge* Impl_;
};

class TSolomonCounterBackend: public ICounterSensorBackend {
public:
    TSolomonCounterBackend(const TSensorGroup& group, TStringBuf name, NMonitoring::TMetricRegistry& registry)
        : Impl_(registry.Rate(NPrivate::CreateLabels(group, name)))
    {
    }

    void Add(ui64 x) override {
        Impl_->Add(x);
    }

private:
    // TODO(avitella): Rename all "Counter" sensors cause its not actual name.
    NMonitoring::TRate* Impl_;
};

} // namespace NInfra
