#pragma once

#include <contrib/libs/grpc/include/grpcpp/impl/codegen/status_code_enum.h>

#include <library/cpp/http/misc/httpcodes.h>

#include <util/generic/yexception.h>

namespace NInfra {
    class TNotImplementedError: public yexception {
    };

    class TAccessDeniedError: public yexception {
    };

    class TServiceError: public yexception {
    public:
        TServiceError(HttpCodes httpCode, grpc::StatusCode statusCode)
            : HttpCode_(httpCode)
            , StatusCode_(statusCode)
        {
        }

    HttpCodes GetHttpCode() const {
        return HttpCode_;
    }

    grpc::StatusCode GetGrpcStatusCode() const {
        return StatusCode_;
    }

    private:
        const HttpCodes HttpCode_;
        const grpc::StatusCode StatusCode_;
    };
}
