#include "make_events.h"

namespace NInfra {

NEventlog::TAttributes MakeAttributesEvent(const TAttributes& attributes) {
    NEventlog::TAttributes event;
    event.MutableAttributes()->Reserve(attributes.size());
    for (const auto& [key, value] : attributes) {
        NEventlog::TAttribute& attribute = *event.AddAttributes();
        attribute.SetKey(key);
        attribute.SetValue(value);
    }
    return event;
}

} // namespace NInfra
