#include "fake_routers.h"

#include <util/datetime/base.h>

namespace NInfra {
    bool TFakeSuccessRouter::DoHas(TStringBuf) const {
        return true;
    }

    TRouterResponse TFakeSuccessRouter::Handle(TStringBuf, const TString&, const TVector<std::pair<TString, TString>>&) const {
        return {TString("Data"), TAttributes()};
    }

    bool TFakeFailureRouter::DoHas(TStringBuf) const {
        return false;
    }

    TRouterResponse TFakeFailureRouter::Handle(TStringBuf, const TString&, const TVector<std::pair<TString, TString>>&) const {
        return {TString("Data"), TAttributes()};
    }

    bool TFakeSlowRouter::DoHas(TStringBuf) const {
        return true;
    }

    TRouterResponse TFakeSlowRouter::Handle(TStringBuf, const TString&, const TVector<std::pair<TString, TString>>&) const {
        Sleep(TDuration::Seconds(1));
        return {TString("Data"), TAttributes()};
    }

}
