#pragma once

#include "router.h"

#include <util/generic/vector.h>
#include <util/system/mutex.h>

namespace NInfra {
    namespace {
        class TFakeBaseRouter: public IRequestRouter {
        public:
            bool Has(TStringBuf path) const override final {
                {
                    TGuard<TMutex> guard(Mutex_);
                    ++Count_;
                    Paths_.push_back(TString{path});
                }
                return DoHas(path);
            }

            size_t GetRequestsCount() const {
                TGuard<TMutex> guard(Mutex_);
                return Count_;
            }

            const TVector<TString> GetPaths() const {
                TGuard<TMutex> guard(Mutex_);
                return Paths_;
            }

        protected:
            virtual bool DoHas(TStringBuf) const = 0;

        protected:
            mutable size_t Count_ = 0;
            mutable TVector<TString> Paths_;
            TMutex Mutex_;
        };

    }

    class TFakeSuccessRouter: public TFakeBaseRouter {
    public:
        TRouterResponse Handle(TStringBuf, const TString&, const TVector<std::pair<TString, TString>>&) const override;

    private:
        bool DoHas(TStringBuf) const override;

    private:
        using TFakeBaseRouter::Count_;
        using TFakeBaseRouter::Paths_;
    };

    class TFakeFailureRouter: public TFakeBaseRouter {
    public:
        TRouterResponse Handle(TStringBuf, const TString&, const TVector<std::pair<TString, TString>>&) const override;

    private:
        bool DoHas(TStringBuf) const override;

    private:
        using TFakeBaseRouter::Count_;
        using TFakeBaseRouter::Paths_;
    };

    class TFakeSlowRouter: public TFakeBaseRouter {
    public:
        TRouterResponse Handle(TStringBuf, const TString&, const TVector<std::pair<TString, TString>>&) const override;

    private:
        bool DoHas(TStringBuf) const override;

    private:
        using TFakeBaseRouter::Count_;
        using TFakeBaseRouter::Paths_;
    };

}
