#pragma once

#include <util/generic/hash.h>
#include <util/generic/ptr.h>

namespace NInfra {
    using TAttributes = THashMultiMap<TString, TString>;

    template <typename Message>
    class IReply {
    public:
        using TMessage = Message;

        IReply(TAttributes& attrs)
            : Attributes_(attrs)
        {
        }

        virtual void Set(const TMessage& message) = 0;

        virtual ~IReply() = default;

        void SetAttribute(const TString& name, const TString& value) {
            Attributes_.emplace(name, value);
        }

    private:
        TAttributes& Attributes_;
    };

    template <typename TMessage>
    using TReplyPtr = TSimpleSharedPtr<IReply<TMessage>>;

    template <typename TReply, typename... TArgs>
    TReplyPtr<typename TReply::TMessage> ReplyPtr(TArgs&&... args) {
        return MakeSimpleShared<TReply>(std::forward<TArgs>(args)...);
    }

}
