#pragma once

#include <util/generic/ptr.h>
#include <util/generic/hash.h>

namespace NInfra {
    using TAttributes = THashMultiMap<TString, TString>;

    template <typename Message>
    class IRequest {
    public:
        using TMessage = Message;

        IRequest(TStringBuf path, const TAttributes& attrs)
            : Path_(path)
            , Attributes_(attrs)
        {
        }

        virtual const TMessage& Get() const = 0;

        virtual ~IRequest() = default;

        const TString& Path() const {
            return Path_;
        }

        const TAttributes& Attributes() const {
            return Attributes_;
        }

    private:
        TString Path_;
        TAttributes Attributes_;
    };

    template <typename TMessage>
    using TRequestPtr = TSimpleSharedPtr<IRequest<TMessage>>;

    template <typename TRequest, typename... TArgs>
    TRequestPtr<typename TRequest::TMessage> RequestPtr(TArgs&&... args) {
        return MakeSimpleShared<TRequest>(std::forward<TArgs>(args)...);
    }

}
