#pragma once

#include <infra/libs/logger/logger.h>

#include <infra/libs/udp_metrics/api/api.pb.h>
#include <infra/libs/udp_metrics/client/config/config.pb.h>

#include <infra/yp_service_discovery/libs/sdlib/manager.h>
#include <infra/yp_service_discovery/libs/sdlib/grpc_resolver/grpc_resolver.h>

#include <library/cpp/udp/client/client.h>
#include <library/cpp/logger/log.h>

#include <util/network/socket.h>
#include <util/system/rwlock.h>

namespace NUdpMetrics {

template <typename TRequest = NApi::TReqIncreaseMetrics>
class TClient {
public:
    TClient(TNetworkAddress address)
        : Address_(std::move(address))
    {
    }

    virtual ~TClient() = default;

    bool IncreaseMetrics(const TRequest& request) const {
        TString data;
        if (Y_UNLIKELY(!request.SerializeToString(&data))) {
            return false;
        }

        NUdp::SendUdpPacket(Address_, data);
        return true;
    }

private:
    TNetworkAddress Address_;
};

template <typename TRequest = NApi::TReqIncreaseMetrics>
class TSelfBalancingClient {
    class TEndpointsProvider;
public:
    TSelfBalancingClient(TSelfBalancingClientConfig config, NInfra::TLogger& logger);

    bool IncreaseMetrics(const TRequest& request) const;

    void ReopenLogs();

private:
    TLog CreateLogger(const TLoggerConfig& config) const;

    bool PingEndpoint(const TNetworkAddress& address, NInfra::TLogFramePtr framePtr) const;
    void UpdateClient();

private:
    const TSelfBalancingClientConfig Config_;

    NInfra::TLogger& Logger_;
    TLog EndpointSetManagerLogger_;

    THolder<IThreadPool> EndpointSetManagerStartPool_;

    NYP::NServiceDiscovery::IRemoteRequesterPtr ServiceDiscoveryResolver_;
    NYP::NServiceDiscovery::TEndpointSetManager EndpointSetManager_;

    TVector<TEndpointsProvider*> UdpMetricsLocalEndpointsProviders_;
    TVector<TEndpointsProvider*> UdpMetricsEndpointsProviders_;

    TRWMutex Mutex_;
    THolder<TClient<TRequest>> UdpMetricsClient_;
};

} // namespace NUdpMetrics

#include "client-inl.h"
