#pragma once

#include <infra/libs/udp_metrics/config/config.pb.h>
#include <infra/libs/udp_metrics/service/service.h>

#include <library/cpp/json/json_writer.h>
#include <library/cpp/protobuf/json/proto2json.h>

#include <library/cpp/proto_config/load.h>

namespace NUdpMetrics {

template <typename TMetricsService = TService>
int RunDaemon(const TUdpMetricsServiceConfig& config) {
    static_assert(std::is_base_of<TService, TMetricsService>::value);

    TMetricsService service(config);
    service.Start();
    service.Wait();

    return EXIT_SUCCESS;
}

template <typename TMetricsService = TService>
int RunDaemon(const NProtoConfig::TLoadConfigOptions& options) {
    const auto config = NProtoConfig::LoadWithOptions<TUdpMetricsServiceConfig>(options);
    return RunDaemon<TMetricsService>(config);
}

template <typename TMetricsService = TService>
int RunDaemon(int argc, const char* argv[], const TString& configResource) {
    const auto config = NProtoConfig::GetOpt<TUdpMetricsServiceConfig>(argc, argv, configResource);
    return RunDaemon<TMetricsService>(config);
}

} // namespace NUdpMetrics
