#include "router_api.h"

#include <infra/libs/service_iface/str_iface.h>

namespace NUdpMetrics {

void CheckPathNotExists(const NInfra::TRequestRouter<IApi>& router, const TStringBuf path) {
    if (router.Has(path)) {
        ythrow yexception() << "Failed to register handler with path \"" << path << "\". Handler with this path already exists.";
    }
}

NInfra::TRequestRouterPtr CreateRouter(IApi& service, const TMetricsCrossSectionsConfig& config) {
    auto router = MakeSimpleShared<NInfra::TRequestRouter<IApi>>(service);

    (*router)
        .Add<NInfra::TEmptyRequest<NApi::TReqPing>, NInfra::TRawDataReply<NApi::TRspPing>>("/ping", "Ping", &IApi::Ping)
        .Add<NInfra::TEmptyRequest<NApi::TReqSensors>, NInfra::TRawDataReply<NApi::TRspSensors>>("/sensors", "Show sensors", &IApi::Sensors)
        .Add<NInfra::TEmptyRequest<NApi::TReqSensors>, NInfra::TRawDataReply<NApi::TRspSensors>>("/sensors/json", "Show sensors in JSON format", &IApi::SensorsJson)
        .Add<NInfra::TEmptyRequest<NApi::TReqReopenLog>, NInfra::TRawDataReply<NApi::TRspReopenLog>>("/reopen_log", "Reopen log", &IApi::ReopenLog)
        .Add<NInfra::TEmptyRequest<NApi::TReqShutdown>, NInfra::TRawDataReply<NApi::TRspShutdown>>("/shutdown", "Shutdown", &IApi::Shutdown)
        .Add<NInfra::TSerializedProtoRequest<NApi::TReqIncreaseMetrics>, NInfra::TSerializedProtoReply<NApi::TRspIncreaseMetrics>>("/increase_metrics", "Increase metric value", &IApi::IncreaseMetrics)
        .Add<NInfra::TJson2ProtoRequest<NApi::TReqIncreaseMetrics>, NInfra::TProto2JsonReply<NApi::TRspIncreaseMetrics>>("/increase_metrics/json", "Increase metric value", &IApi::IncreaseMetrics);

    for (const TMetricsCrossSectionsConfig::TCrossSectionConfig& metricsConfig : config.GetCrossSections()) {
        const TSensorHandle& handleConfig = metricsConfig.GetFetchHandle();
        CheckPathNotExists(*router, handleConfig.GetPath());
        CheckPathNotExists(*router, handleConfig.GetPath() + "/json");
        (*router)
            .Add<NInfra::TEmptyRequest<NApi::TReqSensors>, NInfra::TRawDataReply<NApi::TRspSensors>>(handleConfig.GetPath(), handleConfig.GetDescription(), &IApi::Sensors)
            .Add<NInfra::TEmptyRequest<NApi::TReqSensors>, NInfra::TRawDataReply<NApi::TRspSensors>>(handleConfig.GetPath() + "/json", handleConfig.GetDescription() + " (JSON format)", &IApi::SensorsJson);
    }

    return router;
}

} // namespace NUdpMetrics
