#pragma once

#include <library/cpp/monlib/metrics/labels.h>
#include <library/cpp/monlib/metrics/metric.h>

#include <util/generic/noncopyable.h>

namespace NUdpMetrics::NSensors {

class ISensorsStorage: TNonCopyable {
public:
    using TLabels = NMonitoring::TLabels;
    using TSensor = NMonitoring::IMetricPtr;

    class ISensorAccessor: public NMonitoring::IMetric {
    };

    class IRateSensorAccessor: public NMonitoring::IRate {
    public:
        virtual bool Init() noexcept = 0;
        virtual TMaybe<ui64> TryGet() const noexcept = 0;
    };

public:
    virtual size_t Size() const = 0;

    virtual THolder<ISensorAccessor> Sensor(TLabels labels) = 0;
    virtual THolder<IRateSensorAccessor> Rate(TLabels labels) = 0;

    virtual void Delete(TLabels labels) = 0;

    virtual ~ISensorsStorage() = default;
};

} // namespace NUdpMetrics::NSensors
