#pragma once

#include "concurrent_hash_map.h"

#include <infra/libs/udp_metrics/sensors/sensors_storage.h>

#include <library/cpp/monlib/metrics/labels.h>
#include <library/cpp/monlib/metrics/metric.h>

namespace NUdpMetrics::NSensors {

class TSensorsStorage: public ISensorsStorage {
    using TConcurrentHashMap = TConcurrentHashMap<TLabels, TSensor, /* Buckets */ 64>;
public:
    class TSensorAccessor;
    friend class TSensorAccessor;

    class TRateSensorAccessor;
    friend class TRateSensorAccessor;

public:
    TSensorsStorage(const ui64 reserveSize);

    size_t Size() const override;

    THolder<ISensorAccessor> Sensor(TLabels labels) override;

    THolder<IRateSensorAccessor> Rate(TLabels labels) override;

    void Delete(TLabels labels) override;

private:
    TConcurrentHashMap Values_;
};

/// TSensorsStorage Accessors

class TSensorsStorage::TSensorAccessor: public ISensorAccessor {
public:
    TSensorAccessor(TLabels labels, TSensorsStorage* storage);

    NMonitoring::EMetricType Type() const noexcept override;

    void Accept(TInstant time, NMonitoring::IMetricConsumer* consumer) const override;

private:
    const TLabels Labels_;
    TSensorsStorage* Storage_;
};

class TSensorsStorage::TRateSensorAccessor: public IRateSensorAccessor {
public:
    TRateSensorAccessor(TLabels labels, TSensorsStorage* storage);

    bool Init() noexcept override;
    ui64 Inc() noexcept override;
    ui64 Add(ui64 n) noexcept override;
    ui64 Get() const noexcept override;
    void Reset() noexcept override;
    TMaybe<ui64> TryGet() const noexcept override;

    void Accept(TInstant time, NMonitoring::IMetricConsumer* consumer) const override;

private:
    const TLabels Labels_;
    TSensorsStorage* Storage_;
};

} // namespace NUdpMetrics::NSensors
