#include "storage.h"

namespace NUdpMetrics::NSensors {

TTBBSensorsStorage::TTBBSensorsStorage(const ui64 reserveSize)
    : Values_(reserveSize)
{
}

size_t TTBBSensorsStorage::Size() const {
    return Values_.size();
}

THolder<TTBBSensorsStorage::ISensorAccessor> TTBBSensorsStorage::Sensor(TLabels labels) {
    return MakeHolder<TSensorAccessor>(std::move(labels), this);
}

THolder<TTBBSensorsStorage::IRateSensorAccessor> TTBBSensorsStorage::Rate(TLabels labels) {
    return MakeHolder<TRateSensorAccessor>(std::move(labels), this);
}

void TTBBSensorsStorage::Delete(TLabels labels) {
    Values_.erase(std::move(labels));
}

/// TTBBSensorsStorage::TSensorAccessor

TTBBSensorsStorage::TSensorAccessor::TSensorAccessor(TLabels labels, TTBBSensorsStorage* storage)
    : Labels_(std::move(labels))
    , Storage_(storage)
{
}

NMonitoring::EMetricType TTBBSensorsStorage::TSensorAccessor::Type() const noexcept {
    TConcurrentHashMap::const_accessor accessor;
    if (Storage_->Values_.find(accessor, Labels_)) {
        return accessor->second->Type();
    }
    return NMonitoring::EMetricType::UNKNOWN;
}

void TTBBSensorsStorage::TSensorAccessor::Accept(TInstant time, NMonitoring::IMetricConsumer* consumer) const {
    TConcurrentHashMap::const_accessor accessor;
    if (Storage_->Values_.find(accessor, Labels_)) {
        accessor->second->Accept(time, consumer);
    }
}

/// TTBBSensorsStorage::TRateSensorAccessor

TTBBSensorsStorage::TRateSensorAccessor::TRateSensorAccessor(TLabels labels, TTBBSensorsStorage* storage)
    : Labels_(std::move(labels))
    , Storage_(storage)
{
}

ui64 TTBBSensorsStorage::TRateSensorAccessor::Inc() noexcept {
    TConcurrentHashMap::const_accessor accessor;
    if (!Storage_->Values_.emplace(accessor, Labels_, MakeHolder<NMonitoring::TRate>(1))) {
        return static_cast<NMonitoring::TRate*>(accessor->second.Get())->Inc();
    }
    return 1;
}

ui64 TTBBSensorsStorage::TRateSensorAccessor::Add(ui64 n) noexcept {
    TConcurrentHashMap::const_accessor accessor;
    if (!Storage_->Values_.emplace(accessor, Labels_, MakeHolder<NMonitoring::TRate>(n))) {
        return static_cast<NMonitoring::TRate*>(accessor->second.Get())->Add(n);
    }
    return n;
}

ui64 TTBBSensorsStorage::TRateSensorAccessor::Get() const noexcept {
    TConcurrentHashMap::const_accessor accessor;
    if (Storage_->Values_.find(accessor, Labels_)) {
        return static_cast<NMonitoring::TRate*>(accessor->second.Get())->Get();
    }
    return 0;
}

TMaybe<ui64> TTBBSensorsStorage::TRateSensorAccessor::TryGet() const noexcept {
    TConcurrentHashMap::const_accessor accessor;
    if (Storage_->Values_.find(accessor, Labels_)) {
        return static_cast<NMonitoring::TRate*>(accessor->second.Get())->Get();
    }
    return Nothing();
}

void TTBBSensorsStorage::TRateSensorAccessor::Accept(TInstant time, NMonitoring::IMetricConsumer* consumer) const {
    TConcurrentHashMap::const_accessor accessor;
    if (Storage_->Values_.find(accessor, Labels_)) {
        accessor->second->Accept(time, consumer);
    }
}

} // namespace NUdpMetrics::NSensors
