#pragma once

#include <infra/libs/udp_metrics/sensors/sensors_storage.h>

#include <library/cpp/monlib/metrics/labels.h>
#include <library/cpp/monlib/metrics/metric.h>

#include <contrib/libs/tbb/include/tbb/concurrent_hash_map.h>

namespace NUdpMetrics::NSensors {

class TTBBSensorsStorage: public ISensorsStorage {
    struct TLabelsHashCompare {
        static bool equal(const TLabels& lhs, const TLabels& rhs) {
            return lhs == rhs;
        }

        static size_t hash(const TLabels& labels) {
            return labels.Hash();
        }
    };

    using TConcurrentHashMap = tbb::concurrent_hash_map<TLabels, TSensor, TLabelsHashCompare>;
public:
    class TSensorAccessor;
    friend class TSensorAccessor;

    class TRateSensorAccessor;
    friend class TRateSensorAccessor;

public:
    TTBBSensorsStorage(const ui64 reserveSize);

    size_t Size() const override;

    THolder<ISensorAccessor> Sensor(TLabels labels) override;

    THolder<IRateSensorAccessor> Rate(TLabels labels) override;

    void Delete(TLabels labels) override;

private:
    TConcurrentHashMap Values_;
};

/// TTBBSensorsStorage Accessors

class TTBBSensorsStorage::TSensorAccessor: public ISensorAccessor {
public:
    TSensorAccessor(TLabels labels, TTBBSensorsStorage* storage);

    NMonitoring::EMetricType Type() const noexcept override;

    void Accept(TInstant time, NMonitoring::IMetricConsumer* consumer) const override;

private:
    const TLabels Labels_;
    TTBBSensorsStorage* Storage_;
};

class TTBBSensorsStorage::TRateSensorAccessor: public IRateSensorAccessor {
public:
    TRateSensorAccessor(TLabels labels, TTBBSensorsStorage* storage);

    ui64 Inc() noexcept override;
    ui64 Add(ui64 n) noexcept override;
    ui64 Get() const noexcept override;
    TMaybe<ui64> TryGet() const noexcept override;

    void Accept(TInstant time, NMonitoring::IMetricConsumer* consumer) const override;

private:
    const TLabels Labels_;
    TTBBSensorsStorage* Storage_;
};

} // namespace NUdpMetrics::NSensors
