#pragma once

#include <infra/libs/udp_metrics/config/config.pb.h>
#include <infra/libs/udp_metrics/sensors/sensors_registry.h>
#include <infra/libs/udp_metrics/sensors/storages/storage/storage.h>
#include <infra/libs/udp_metrics/service_iface/service_iface.h>

#include <infra/libs/http_service/service.h>
#include <infra/libs/sensors/sensor_group.h>
#include <infra/libs/udp_service/service.h>
#include <infra/libs/logger/logger.h>

#include <util/generic/fwd.h>
#include <util/generic/set.h>

namespace NUdpMetrics {
class TMetricsCrossSection {
    using TSensorsRegistry = NSensors::TSensorsRegistry<NSensors::TSensorsStorage>;
    using TConfig = TMetricsCrossSectionsConfig::TCrossSectionConfig;

public:
    TMetricsCrossSection(TConfig config);

    const TConfig Config;
    const TString Name;
    const TSet<TString> Labels;
    THolder<TSensorsRegistry> SensorsRegistry;

    bool IsSuitableForMetric(const NApi::TMetric& metric) const;
};

class TService: public IService {
    using TSensorsRegistry = NSensors::TSensorsRegistry<NSensors::TSensorsStorage>;

public:
    TService(TUdpMetricsServiceConfig config);
    virtual ~TService() = default;

    void Start() override;
    void Wait() override;

    void Ping(NInfra::TRequestPtr<NApi::TReqPing> request, NInfra::TReplyPtr<NApi::TRspPing> reply) override;

    void SensorsJson(NInfra::TRequestPtr<NApi::TReqSensors> request, NInfra::TReplyPtr<NApi::TRspSensors> reply) override;

    void Sensors(NInfra::TRequestPtr<NApi::TReqSensors> request, NInfra::TReplyPtr<NApi::TRspSensors> reply) override;

    void ReopenLog(NInfra::TRequestPtr<NApi::TReqReopenLog>, NInfra::TReplyPtr<NApi::TRspReopenLog> reply) override;

    void Shutdown(NInfra::TRequestPtr<NApi::TReqShutdown> request, NInfra::TReplyPtr<NApi::TRspShutdown> reply) override;

    void HandleUdpRequest(NUdp::TUdpPacket packet) override;

    void IncreaseMetrics(NInfra::TRequestPtr<NApi::TReqIncreaseMetrics> request, NInfra::TReplyPtr<NApi::TRspIncreaseMetrics> reply) override;

private:
    virtual NInfra::TRequestPtr<NApi::TReqIncreaseMetrics> ParseUdpPacket(NUdp::TUdpPacket packet, NInfra::TLogFramePtr logFrame) const;

    void IncreaseMetrics(NInfra::TRequestPtr<NApi::TReqIncreaseMetrics> request, NInfra::TReplyPtr<NApi::TRspIncreaseMetrics> reply, NInfra::TLogFramePtr logFrame);

private:
    TVector<NInfra::TSensorGroup> MakeSensors(const NApi::TMetric& metric, const TMetricsCrossSection& crossSection) const;

    TSensorsRegistry* FindRegistry(const TStringBuf name) const;

private:
    const TUdpMetricsServiceConfig Config_;

    NInfra::TUdpService UdpService_;
    NInfra::THttpService HttpService_;

    NInfra::TLogger Logger_;

    TSensorsRegistry StatsSensorRegistry_;

    TVector<TMetricsCrossSection> MetricsCrossSections_;
};

} // namespace NUdpMetrics
