#include "service.h"

#include <infra/libs/udp_metrics/api/api.pb.h>
#include <infra/libs/udp_metrics/config/config.pb.h>
#include <library/cpp/protobuf/json/json2proto.h>
#include <library/cpp/testing/unittest/registar.h>

NUdpMetrics::NApi::TMetric GetEmptyClickMetric() {
    NUdpMetrics::NApi::TMetric metric;
    metric.SetName("click");
    (*metric.MutableLabels())["bucket"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["device"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["service_name"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["subservice"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["testid"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["wizard"].AddValues()->MutableNotSet();
    return metric;
}

NUdpMetrics::NApi::TMetric GetClickMetric1() {
    NUdpMetrics::NApi::TMetric metric;
    metric.SetName("click");
    (*metric.MutableLabels())["bucket"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["bucket"].AddValues()->SetValue("0");
    (*metric.MutableLabels())["device"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["service_name"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["service_name"].AddValues()->SetValue("web");
    (*metric.MutableLabels())["subservice"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["subservice"].AddValues()->SetValue("");
    (*metric.MutableLabels())["testid"].AddValues()->SetValue("186144");
    (*metric.MutableLabels())["wizard"].AddValues()->MutableNotSet();
    return metric;
}

NUdpMetrics::NApi::TMetric GetClickMetric2() {
    NUdpMetrics::NApi::TMetric metric;
    metric.SetName("click");
    (*metric.MutableLabels())["bucket"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["bucket"].AddValues()->SetValue("1");
    (*metric.MutableLabels())["device"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["device"].AddValues()->SetValue("desktop");
    (*metric.MutableLabels())["service_name"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["service_name"].AddValues()->SetValue("web");
    (*metric.MutableLabels())["subservice"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["subservice"].AddValues()->SetValue("");
    (*metric.MutableLabels())["testid"].AddValues()->SetValue("186144");
    (*metric.MutableLabels())["wizard"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["wizard"].AddValues()->SetValue("organic");
    return metric;
}

NUdpMetrics::NApi::TMetric GetClickMetric3() {
    NUdpMetrics::NApi::TMetric metric;
    metric.SetName("click");
    (*metric.MutableLabels())["bucket"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["bucket"].AddValues()->SetValue("1");
    (*metric.MutableLabels())["device"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["device"].AddValues()->SetValue("desktop");
    (*metric.MutableLabels())["service_name"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["service_name"].AddValues()->SetValue("web");
    (*metric.MutableLabels())["subservice"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["subservice"].AddValues()->SetValue("");
    (*metric.MutableLabels())["testid"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["wizard"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["wizard"].AddValues()->SetValue("organic");
    return metric;
}

NUdpMetrics::NApi::TMetric GetClickMetric4() {
    NUdpMetrics::NApi::TMetric metric;
    metric.SetName("click");
    (*metric.MutableLabels())["device"].AddValues()->SetValue("desktop");
    (*metric.MutableLabels())["service_name"].AddValues()->SetValue("web");
    (*metric.MutableLabels())["subservice"].AddValues()->SetValue("");
    (*metric.MutableLabels())["wizard"].AddValues()->SetValue("organic");
    (*metric.MutableLabels())["geo"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["contour"].AddValues()->MutableNotSet();
    return metric;
}

NUdpMetrics::NApi::TMetric GetQuasarMetric() {
    NUdpMetrics::NApi::TMetric metric;
    metric.SetName("ysk_ps_session_stats");
    (*metric.MutableLabels())["Platform"].AddValues()->SetValue("yandexmini");
    (*metric.MutableLabels())["QuasmodromGroup"].AddValues()->SetValue("production");
    (*metric.MutableLabels())["SoftwareVersion"].AddValues()->SetValue("1.3.4.21.643500603.20200401");
    return metric;
}

NUdpMetrics::NApi::TMetric GetQuasarMergedWithEmptyClickMetric() {
    NUdpMetrics::NApi::TMetric metric;
    metric.SetName("ysk_ps_session_stats");
    (*metric.MutableLabels())["Platform"].AddValues()->SetValue("yandexmini");
    (*metric.MutableLabels())["QuasmodromGroup"].AddValues()->SetValue("production");
    (*metric.MutableLabels())["SoftwareVersion"].AddValues()->SetValue("1.3.4.21.643500603.20200401");
    (*metric.MutableLabels())["bucket"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["device"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["service_name"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["subservice"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["testid"].AddValues()->MutableNotSet();
    (*metric.MutableLabels())["wizard"].AddValues()->MutableNotSet();
    return metric;
}

NUdpMetrics::NApi::TMetric GetGeoContourClickMetric() {
    NUdpMetrics::NApi::TMetric metric;
    metric.SetName("click");
    (*metric.MutableLabels())["wizard"].AddValues()->SetValue("1");
    (*metric.MutableLabels())["device"].AddValues()->SetValue("2");
    (*metric.MutableLabels())["service_name"].AddValues()->SetValue("3");
    (*metric.MutableLabels())["subservice"].AddValues()->SetValue("4");
    (*metric.MutableLabels())["geo"].AddValues()->SetValue("5");
    (*metric.MutableLabels())["contour"].AddValues()->SetValue("6");
    return metric;
}

NUdpMetrics::NApi::TMetric GetMegamindIntentsMetric() {
    NUdpMetrics::NApi::TMetric metric;
    metric.SetName("megamind_intents");
    (*metric.MutableLabels())["Intent"].AddValues()->SetValue("personal_assistant.awesome.intent");
    (*metric.MutableLabels())["ScenarioName"].AddValues()->SetValue("vins");
    (*metric.MutableLabels())["IsWinnerScenario"].AddValues()->SetValue("true");
    return metric;
}

NUdpMetrics::NApi::TMetric GetMegamindIrrelevantMetric() {
    NUdpMetrics::NApi::TMetric metric;
    metric.SetName("megamind_irrelevant");
    (*metric.MutableLabels())["IntentName"].AddValues()->SetValue("personal_assistant.awesome.intent");
    (*metric.MutableLabels())["ScenarioName"].AddValues()->SetValue("vins");
    return metric;
}

NUdpMetrics::NApi::TMetric GetMordaMonitoringMetric() {
    NUdpMetrics::NApi::TMetric metric;
    metric.SetName("click");
    (*metric.MutableLabels())["path"].AddValues()->SetValue("touch_gramps.news");
    (*metric.MutableLabels())["device"].AddValues()->SetValue("touch_gramps");
    return metric;
}

NUdpMetrics::NApi::TMetric GetMordaMonitoringGeoContourMetric() {
    NUdpMetrics::NApi::TMetric metric;
    metric.SetName("click");
    (*metric.MutableLabels())["path"].AddValues()->SetValue("touch_gramps.news");
    (*metric.MutableLabels())["device"].AddValues()->SetValue("touch_gramps");
    (*metric.MutableLabels())["geo"].AddValues()->SetValue("sas");
    (*metric.MutableLabels())["contour"].AddValues()->SetValue("prod");
    return metric;
}

constexpr TStringBuf TEST_ID_CROSSSECTION = TStringBuf(R"(
{
    "MaxSensorsNumber": 50000,
    "Labels": [
        "testid",
        "bucket"
    ],
    "FetchHandle": {
        "Path": "/sensors/test_id"
    }
}
)");

constexpr TStringBuf WIZARD_DEVICE_CROSSSECTION = TStringBuf(R"(
{
    "MaxSensorsNumber": 10000,
    "Labels": [
        "service_name",
        "subservice",
        "wizard",
        "device"
    ],
    "FetchHandle": {
        "Path": "/sensors/wizard_device"
    }
}
)");

constexpr TStringBuf WIZARD_TEST_ID_CROSSSECTION = TStringBuf(R"(
{
    "MaxSensorsNumber": 10000,
    "Labels": [
        "wizard",
        "testid",
        "bucket"
    ],
    "FetchHandle": {
        "Path": "/sensors/wizard_test_id"
    }
}
)");

constexpr TStringBuf QUASAR_METRICS_CROSSSECTION = TStringBuf(R"(
{
    "MaxSensorsNumber": 100000,
    "Labels": [
        "Platform",
        "QuasmodromGroup",
        "SoftwareVersion"
    ],
    "FetchHandle": {
        "Path": "/sensors/quasar_metrics"
    }
}
)");

constexpr TStringBuf WIZARD_DEVICE_GEO_CONTOUR_CROSSSECTION = TStringBuf(R"(
{
    "MaxSensorsNumber": 10000,
    "Labels": [
        "service_name",
        "subservice",
        "wizard",
        "device",
        "geo",
        "contour"
    ],
    "FetchHandle": {
        "Path": "/sensors/wizard_device_geo_contour"
    }
}
)");

constexpr TStringBuf MEGAMIND_INTENTS_CROSSSECTION = TStringBuf(R"(
{
    "MaxSensorsNumber": 100000,
    "Labels": [
        "Intent",
        "ScenarioName",
        "IsWinnerScenario"
    ],
    "FetchHandle": {
        "Path": "/sensors/megamind_intents_metrics"
    }
}
)");

constexpr TStringBuf MEGAMIND_IRRELEVANT_CROSSSECTION = TStringBuf(R"(
{
    "MaxSensorsNumber": 100000,
    "Labels": [
        "IntentName",
        "ScenarioName"
    ],
    "FetchHandle": {
        "Path": "/sensors/megamind_irrelevant_metrics"
    }
}
)");

constexpr TStringBuf MORDA_MONITORING_CROSSECTION = TStringBuf(R"(
{
    "MaxSensorsNumber": 100000,
    "Labels": [
        "path",
        "device"
    ],
    "FetchHandle": {
        "Path": "/sensors/morda_monitoring_metrics"
    }
}
)");

constexpr TStringBuf MORDA_MONITORING_GEO_CONTOUR_CROSSECTION = TStringBuf(R"(
{
    "MaxSensorsNumber": 100000,
    "Labels": [
        "path",
        "device",
        "geo",
        "contour"
    ],
    "FetchHandle": {
        "Path": "/sensors/morda_monitoring_metrics_geo_contour"
    }
}
)");

Y_UNIT_TEST_SUITE(CrossSectionTests) {
    Y_UNIT_TEST(TestId) {
        NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig crossSectionConfig = NProtobufJson::Json2Proto<NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig>(TEST_ID_CROSSSECTION);
        NUdpMetrics::TMetricsCrossSection crossSection(crossSectionConfig);
        {
            NUdpMetrics::NApi::TMetric metric = GetEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric1();
            UNIT_ASSERT(crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric2();
            UNIT_ASSERT(crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric3();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMergedWithEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIntentsMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIrrelevantMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringGeoContourMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
    }

    Y_UNIT_TEST(WizardDevice) {
        NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig crossSectionConfig = NProtobufJson::Json2Proto<NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig>(WIZARD_DEVICE_CROSSSECTION);
        NUdpMetrics::TMetricsCrossSection crossSection(crossSectionConfig);
        {
            NUdpMetrics::NApi::TMetric metric = GetEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric1();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric2();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric3();
            UNIT_ASSERT(crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMergedWithEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetGeoContourClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric4();
            UNIT_ASSERT(crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIntentsMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIrrelevantMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringGeoContourMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
    }

    Y_UNIT_TEST(WizardTestId) {
        NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig crossSectionConfig = NProtobufJson::Json2Proto<NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig>(WIZARD_TEST_ID_CROSSSECTION);
        NUdpMetrics::TMetricsCrossSection crossSection(crossSectionConfig);
        {
            NUdpMetrics::NApi::TMetric metric = GetEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric1();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric2();
            UNIT_ASSERT(crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric3();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMergedWithEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIntentsMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIrrelevantMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringGeoContourMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
    }

    Y_UNIT_TEST(QuasarMetrics) {
        NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig crossSectionConfig = NProtobufJson::Json2Proto<NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig>(QUASAR_METRICS_CROSSSECTION);
        NUdpMetrics::TMetricsCrossSection crossSection(crossSectionConfig);
        {
            NUdpMetrics::NApi::TMetric metric = GetEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric1();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric2();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric3();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMetric();
            UNIT_ASSERT(crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMergedWithEmptyClickMetric();
            UNIT_ASSERT(crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIntentsMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIrrelevantMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringGeoContourMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
    }

    Y_UNIT_TEST(WizardDeviceGeoContour) {
        NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig crossSectionConfig = NProtobufJson::Json2Proto<NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig>(WIZARD_DEVICE_GEO_CONTOUR_CROSSSECTION);
        NUdpMetrics::TMetricsCrossSection crossSection(crossSectionConfig);
        {
            NUdpMetrics::NApi::TMetric metric = GetEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric1();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric2();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric3();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMergedWithEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetGeoContourClickMetric();
            UNIT_ASSERT(crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric4();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIntentsMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIrrelevantMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringGeoContourMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
    }

    Y_UNIT_TEST(MegamindIntents) {
        NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig crossSectionConfig =
            NProtobufJson::Json2Proto<NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig>(
                MEGAMIND_INTENTS_CROSSSECTION
        );
        NUdpMetrics::TMetricsCrossSection crossSection(crossSectionConfig);
        {
            NUdpMetrics::NApi::TMetric metric = GetEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric1();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric2();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric3();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMergedWithEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetGeoContourClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric4();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIntentsMetric();
            UNIT_ASSERT(crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIrrelevantMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringGeoContourMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
    }

    Y_UNIT_TEST(MegamindIrrelevant) {
        NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig crossSectionConfig =
            NProtobufJson::Json2Proto<NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig>(
                MEGAMIND_IRRELEVANT_CROSSSECTION
        );
        NUdpMetrics::TMetricsCrossSection crossSection(crossSectionConfig);
        {
            NUdpMetrics::NApi::TMetric metric = GetEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric1();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric2();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric3();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMergedWithEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetGeoContourClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric4();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIntentsMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIrrelevantMetric();
            UNIT_ASSERT(crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringGeoContourMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
    }

    Y_UNIT_TEST(MordaMonitoring) {
        NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig crossSectionConfig =
            NProtobufJson::Json2Proto<NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig>(
                MORDA_MONITORING_CROSSECTION
        );
        NUdpMetrics::TMetricsCrossSection crossSection(crossSectionConfig);
        {
            NUdpMetrics::NApi::TMetric metric = GetEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric1();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric2();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric3();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMergedWithEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetGeoContourClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric4();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIntentsMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIrrelevantMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringMetric();
            UNIT_ASSERT(crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringGeoContourMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
    }

    Y_UNIT_TEST(MordaMonitoringGeoContour) {
        NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig crossSectionConfig =
            NProtobufJson::Json2Proto<NUdpMetrics::TMetricsCrossSectionsConfig::TCrossSectionConfig>(
                MORDA_MONITORING_GEO_CONTOUR_CROSSECTION
        );
        NUdpMetrics::TMetricsCrossSection crossSection(crossSectionConfig);
        {
            NUdpMetrics::NApi::TMetric metric = GetEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric1();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric2();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric3();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetQuasarMergedWithEmptyClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetGeoContourClickMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetClickMetric4();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIntentsMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMegamindIrrelevantMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringMetric();
            UNIT_ASSERT(!crossSection.IsSuitableForMetric(metric));
        }
        {
            NUdpMetrics::NApi::TMetric metric = GetMordaMonitoringGeoContourMetric();
            UNIT_ASSERT(crossSection.IsSuitableForMetric(metric));
        }
    }
}
