#pragma once

#include <infra/libs/udp_metrics/api/api.pb.h>
#include <infra/libs/udp_metrics/api/internal.pb.h>

#include <infra/libs/service_iface/errors.h>
#include <infra/libs/service_iface/reply.h>
#include <infra/libs/service_iface/request.h>
#include <infra/libs/service_iface/router.h>

#include <library/cpp/udp/server/packet.h>

namespace NUdpMetrics {

class IApi {
public:
    virtual void Ping(NInfra::TRequestPtr<NApi::TReqPing>, NInfra::TReplyPtr<NApi::TRspPing>) {
        ythrow NInfra::TNotImplementedError();
    }

    virtual void SensorsJson(NInfra::TRequestPtr<NApi::TReqSensors>, NInfra::TReplyPtr<NApi::TRspSensors>) {
        ythrow NInfra::TNotImplementedError();
    }

    virtual void Sensors(NInfra::TRequestPtr<NApi::TReqSensors>, NInfra::TReplyPtr<NApi::TRspSensors>) {
        ythrow NInfra::TNotImplementedError();
    }

    virtual void ReopenLog(NInfra::TRequestPtr<NApi::TReqReopenLog>, NInfra::TReplyPtr<NApi::TRspReopenLog>) {
        ythrow NInfra::TNotImplementedError();
    }

    virtual void Shutdown(NInfra::TRequestPtr<NApi::TReqShutdown>, NInfra::TReplyPtr<NApi::TRspShutdown>) {
        ythrow NInfra::TNotImplementedError();
    }

    virtual void HandleUdpRequest(NUdp::TUdpPacket) {
        ythrow NInfra::TNotImplementedError();
    }

    virtual void IncreaseMetrics(NInfra::TRequestPtr<NApi::TReqIncreaseMetrics>, NInfra::TReplyPtr<NApi::TRspIncreaseMetrics>) {
        ythrow NInfra::TNotImplementedError();
    }

    virtual ~IApi() = default;
};

} // namespace NUdpMetrics
