#include <infra/libs/logger/log_printer.h>
#include <infra/libs/udp_metrics/daemon/main.h>

#include <library/cpp/getopt/modchooser.h>

int RunDaemon(int argc, const char* argv[]) {
    return NUdpMetrics::RunDaemon(argc, argv, "/udp_metrics_server/proto_config.json");
}

int main(int argc, const char* argv[]) {
    TModChooser modChooser;

    modChooser.AddMode("run",
                       RunDaemon,
                       "Run udp_metrics_server daemon.");

    modChooser.AddMode("print_log",
                       NInfra::PrintEventLog,
                       "Run udp_metrics_server eventlog.");

    try {
        return modChooser.Run(argc, argv);
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}
