#pragma once

#include <infra/libs/logger/logger.h>
#include <infra/libs/udp_service/protos/config.pb.h>

#include <library/cpp/udp/server/server.h>

namespace NInfra {

class TUdpService {
public:
    TUdpService(const TUdpServiceConfig& config,
                NUdp::TCallback callback);

    void Start(TLogFramePtr logFrame);

    void Wait(TLogFramePtr logFrame);

    void ShutDown(TLogFramePtr logFrame);

    void SetErrorCallback(NUdp::TErrorCallback errorCallback);

    void SetQueueOverflowCallback(NUdp::TQueueOverflowCallback queueOverflowCallback);

private:
    TUdpServiceConfig Config_;
    NUdp::TCallback Callback_;
    THolder<NUdp::TUdpServer> Server_;
};

} // namespace NInfra

