#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/udp/client/client.h>

#include <infra/libs/udp_service/service.h>
#include <infra/libs/udp_service/test_common.h>

using namespace NInfra;

Y_UNIT_TEST_SUITE(UdpService) {
    Y_UNIT_TEST(SimpleTest) {
        const TUdpServiceConfig config = NTestCommon::GenerateUdpServiceConfig();

        TLoggerConfig loggerConfig;
        TLogger logger(loggerConfig);
        auto fakeFrame = logger.SpawnFrame();

        THashSet<TString> recievedPackets;
        TUdpService service(config, [&recievedPackets](NUdp::TUdpPacket packet) {
            recievedPackets.emplace(TString(packet.Data.data(), packet.Data.size()));
        });
        service.Start(fakeFrame);

        NUdp::SendUdpPacket(TNetworkAddress("localhost", config.GetPort()), TStringBuf("a"));

        Sleep(TDuration::Seconds(1));

        UNIT_ASSERT(recievedPackets.size() == 1 && *recievedPackets.begin() == "a");
    }
}

