#include "make_events.h"

#include <infra/libs/yp_dns/zone/eventlog/make_events.h>

namespace NYP::DNS {

////////////////////////////////////////////////////////////////////////////////

NUnbound::NEventlog::TZoneInfo MakeZoneInfoEvent(const NYpDns::TZoneConfig& zone) {
    NUnbound::NEventlog::TZoneInfo event;
    event.SetName(zone.GetName());
    event.MutableClusters()->Reserve(zone.GetYPClusters().size());
    for (const TString& cluster : zone.GetYPClusters()) {
        event.AddClusters(cluster);
    }
    return event;
}

////////////////////////////////////////////////////////////////////////////////

const NUnbound::NEventlog::TDetermineZoneResult& DetermineZoneNotFoundResultEvent() {
    static NUnbound::NEventlog::TDetermineZoneResult event = [] {
        NUnbound::NEventlog::TDetermineZoneResult event;
        event.set_status(NUnbound::NEventlog::TDetermineZoneResult::NOT_FOUND);
        return event;
    }();
    return event;
}

////////////////////////////////////////////////////////////////////////////////

NUnbound::NEventlog::TListZonesResultData MakeListZonesResultDataEvent(const NYpDns::TZoneConfig& zone) {
    NUnbound::NEventlog::TListZonesResultData event;
    *event.MutableZoneConfig() = MakeZoneConfigEvent(zone);
    return event;
}

NUnbound::NEventlog::TListDynamicZonesResult MakeListDynamicZonesResultEvent(const NApi::TRspListZones& rsp) {
    NUnbound::NEventlog::TListDynamicZonesResult event;
    event.SetStatus(NApi::TRspListZones::EListZonesStatus_Name(rsp.status()));
    if (!rsp.error_message().empty()) {
        event.SetErrorMessage(rsp.error_message());
    }
    event.SetZonesNumber(rsp.zones().size());
    return event;
}

////////////////////////////////////////////////////////////////////////////////

} // namespace NYP::DNS
