#include "router_api.h"

#include <infra/libs/service_iface/str_iface.h>

#include <infra/libs/version_handle/version_handle.h>

namespace NYP::DNS {
    NInfra::TRequestRouterPtr CreateRouter(IApi& service, const TConfig& config) {
        auto router = MakeSimpleShared<NInfra::TRequestRouter<IApi>>(service);

        (*router)
            .Add<NInfra::TEmptyRequest<NApi::TReqPing>, NInfra::TProto2JsonReply<NApi::TRspPing>>("/ping", "Ping", &IApi::Ping)
            .Add<NInfra::TEmptyRequest<NApi::TReqReopenLog>, NInfra::TProto2JsonReply<NApi::TRspReopenLog>>("/reopen_log", "Reopen log", &IApi::ReopenLog)
            .Add<NInfra::TEmptyRequest<NApi::TReqSensors>, NInfra::TRawDataReply<NApi::TRspSensors>>("/sensors", "Show sensors in SPACK format", &IApi::Sensors)
            .Add<NInfra::TEmptyRequest<NApi::TReqSensors>, NInfra::TRawDataReply<NApi::TRspSensors>>("/sensors/json", "Show sensors in JSON format", &IApi::SensorsJson)
            .Add<NInfra::TEmptyRequest<NApi::TReqConfig>, NInfra::TRawDataReply<NApi::TRspConfig>>("/config", "Show config", &IApi::Config)
            .Add<
                NInfra::TJson2ProtoRequest<NApi::TReqListZoneRecordSets>,
                NInfra::TProto2JsonReply<NApi::TRspListZoneRecordSets, false, NProtobufJson::TProto2JsonConfig::EnumName>
            >("/list_zone_record_sets/json", "List zone record sets (json)", &IApi::ListZoneRecordSets)
            .Add<
                NInfra::TJson2ProtoRequest<NApi::TReqListZoneData>,
                NInfra::TProto2JsonReply<NApi::TRspListZoneData, false, NProtobufJson::TProto2JsonConfig::EnumName>
            >("/list_zone_data/json", "List zone data in zonefile format (json)", &IApi::ListZoneData)
            .Add<
                NInfra::TJson2ProtoRequest<NApi::TReqListZoneData>,
                NInfra::TRawDataReply<NApi::TRspListZoneData>
            >("/list_zone_data/raw", "List zone data in zonefile format (raw)", &IApi::ListZoneDataRaw)
            .Add<
                NInfra::TJson2ProtoRequest<NApi::TReqListZones>,
                NInfra::TProto2JsonReply<NApi::TRspListZones, false, NProtobufJson::TProto2JsonConfig::EnumName>
            >("/list_zones/dynamic/json", "List dynamic zones (json)", &IApi::ListDynamicZones);

        for (const auto& cluster : config.GetYPClusterConfigs()) {
            (*router)
                .Add<NInfra::TEmptyRequest<NApi::TReqListBackups>, NInfra::TProto2JsonReply<NApi::TRspListBackups>>(
                    TString::Join("/backup/", cluster.GetName(), "/list/json"),
                    TString::Join("List backups for ", cluster.GetName(), " (json)"),
                    &IApi::ListBackups
                )
                .Add<NInfra::TEmptyRequest<NApi::TReqListBackups>, NInfra::TSerializedProtoReply<NApi::TRspListBackups>>(
                    TString::Join("/backup/", cluster.GetName(), "/list"),
                    TString::Join("List backups for ", cluster.GetName()),
                    &IApi::ListBackups
                )
                .Add<NInfra::TSerializedProtoRequest<NApi::TReqRollbackToBackup>, NInfra::TProto2JsonReply<NApi::TRspRollbackToBackup>>(
                    TString::Join("/rollback/", cluster.GetName(), "/backup"),
                    TString::Join("Rollback to backup for ", cluster.GetName(), " (json)"),
                    &IApi::RollbackToBackup
                )
                .Add<NInfra::TJson2ProtoRequest<NApi::TReqRollbackToBackup>, NInfra::TSerializedProtoReply<NApi::TRspRollbackToBackup>>(
                    TString::Join("/rollback/", cluster.GetName(), "/backup"),
                    TString::Join("Rollback to backup for ", cluster.GetName()),
                    &IApi::RollbackToBackup
                )
                .Add<NInfra::TEmptyRequest<NApi::TReqStartUpdates>, NInfra::TRawDataReply<NApi::TRspStartUpdates>>(
                    TString::Join("/updates/", cluster.GetName(), "/start"),
                    "Start updates",
                    &IApi::StartUpdates
                )
                .Add<NInfra::TEmptyRequest<NApi::TReqStopUpdates>, NInfra::TRawDataReply<NApi::TRspStopUpdates>>(
                    TString::Join("/updates/", cluster.GetName(), "/stop"),
                    "Stop updates",
                    &IApi::StopUpdates
                );
        }

        NInfra::NVersionHandle::AddBinaryHandlers(*router);

        return router;
    }

}
