#pragma once

#include <infra/libs/unbound/yp_dns/api/api.pb.h>

#include <infra/libs/service_iface/errors.h>
#include <infra/libs/service_iface/reply.h>
#include <infra/libs/service_iface/request.h>
#include <infra/libs/service_iface/router.h>

#include <infra/libs/version_handle/version_handle.h>

namespace NYP::DNS {
    class IApi : public NInfra::NVersionHandle::TBinaryApi {
    public:
        virtual ~IApi() = default;

        virtual void Ping(NInfra::TRequestPtr<NApi::TReqPing>, NInfra::TReplyPtr<NApi::TRspPing>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void ReopenLog(NInfra::TRequestPtr<NApi::TReqReopenLog>, NInfra::TReplyPtr<NApi::TRspReopenLog>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void Sensors(NInfra::TRequestPtr<NApi::TReqSensors>, NInfra::TReplyPtr<NApi::TRspSensors>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void SensorsJson(NInfra::TRequestPtr<NApi::TReqSensors>, NInfra::TReplyPtr<NApi::TRspSensors>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void Config(NInfra::TRequestPtr<NApi::TReqConfig>, NInfra::TReplyPtr<NApi::TRspConfig>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void ListBackups(NInfra::TRequestPtr<NApi::TReqListBackups>, NInfra::TReplyPtr<NApi::TRspListBackups>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void RollbackToBackup(NInfra::TRequestPtr<NApi::TReqRollbackToBackup>, NInfra::TReplyPtr<NApi::TRspRollbackToBackup>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void StartUpdates(NInfra::TRequestPtr<NApi::TReqStartUpdates>, NInfra::TReplyPtr<NApi::TRspStartUpdates>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void StopUpdates(NInfra::TRequestPtr<NApi::TReqStopUpdates>, NInfra::TReplyPtr<NApi::TRspStopUpdates>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void ListZoneRecordSets(NInfra::TRequestPtr<NApi::TReqListZoneRecordSets>, NInfra::TReplyPtr<NApi::TRspListZoneRecordSets>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void ListZoneData(NInfra::TRequestPtr<NApi::TReqListZoneData>, NInfra::TReplyPtr<NApi::TRspListZoneData>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void ListZoneDataRaw(NInfra::TRequestPtr<NApi::TReqListZoneData>, NInfra::TReplyPtr<NApi::TRspListZoneData>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void ListDynamicZones(NInfra::TRequestPtr<NApi::TReqListZones>, NInfra::TReplyPtr<NApi::TRspListZones>) {
            ythrow NInfra::TNotImplementedError();
        }
    };

}
