#pragma once

#include <infra/libs/unified_agent_log_backend/protos/config.pb.h>
#include <library/cpp/logger/backend.h>
#include <util/generic/ptr.h>

namespace NInfra::NUnifiedAgentLogBackend {

class TUnifiedAgentLogBackend: public TLogBackend {
public:
    TUnifiedAgentLogBackend(const TUnifiedAgentLogBackendConfig& config, TLogBackend* slave = nullptr);
    ~TUnifiedAgentLogBackend() override;

    void WriteData(const TLogRecord& rec) override;
    void ReopenLog() override;

    void ReopenLogNoFlush() override;
    size_t SlaveQueueSize() const;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

}
