#pragma once

#include <infra/libs/updatable_proto_config/protos/config.pb.h>

#include <infra/libs/background_thread/background_thread.h>
#include <infra/libs/logger/logger.h>
#include <infra/libs/sensors/sensor_group.h>

#include <library/cpp/json/json_value.h>

#include <util/folder/path.h>
#include <util/system/mutex.h>

namespace NUpdatableProtoConfig {

struct TWatchContext {
    TString Id;
};

struct TWatchResult {
    bool WatchSucceeded;
    bool DiffFound;
};

class TPatchFileWatcher {
public:
    using TCallback = std::function<bool(const TFsPath&, const NJson::TJsonValue&, NInfra::TLogFramePtr logFrame, const TWatchContext& context)>;

    TPatchFileWatcher(const TWatchPatchConfig& config, NInfra::TLogger& logger, const NInfra::TSensorGroup& sensorGroup, TCallback callback);
    ~TPatchFileWatcher();

    void Start();
    void Stop();

    bool Watch(const TWatchContext& context = {}) const;

private:
    TWatchResult WatchFile(const TFsPath& path, bool copyContent, NInfra::TLogFramePtr logFrame, const TWatchContext& context = {}) const;
    bool CopyFile(const TFsPath& from, const TFsPath& to, NInfra::TLogFramePtr logFrame) const;

private:
    TMutex Mutex_;
    const THolder<NInfra::IBackgroundThread> WatchThread_;
    NInfra::TLogger& Logger_;
    const NInfra::TSensorGroup SensorGroup_;
    const TFsPath Path_;
    const TFsPath CopiedPatchPath_;
    const TFsPath ValidPatchPath_;
    const TCallback Callback_;
};

} // namespace NUpdatableProtoConfig
