#include "infra/libs/version_handle/version_handle.h"

#include <infra/yp_service_discovery/libs/service_iface/api.h>
#include <infra/libs/service_iface/router.h>

#include <build/scripts/c_templates/svnversion.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NInfra;
using namespace NInfra::NVersionHandle;

Y_UNIT_TEST_SUITE(BasicAdd) {

    Y_UNIT_TEST(TBinaryApiAdd) {
        TBinaryApi api;
        TRequestRouter router(api);

        UNIT_ASSERT(!router.Has("/version/svn/revision"));
        UNIT_ASSERT(!router.Has("/version/branch"));
        UNIT_ASSERT(!router.Has("/version/commit"));
        UNIT_ASSERT(!router.Has("/version/all"));

        AddBinaryHandlers(router);

        UNIT_ASSERT(router.Has("/version/svn/revision"));
        UNIT_ASSERT(router.Has("/version/branch"));
        UNIT_ASSERT(router.Has("/version/commit"));
        UNIT_ASSERT(router.Has("/version/all"));
    }

    Y_UNIT_TEST(HandleBranch) {
        TBinaryApi api;
        TRequestRouter router(api);
        AddBinaryHandlers(router);
        auto res = router.Handle("/version/branch", "", {});
        UNIT_ASSERT(res.Content == ::GetBranch());
    }

    Y_UNIT_TEST(HandleCommit) {
        TBinaryApi api;
        TRequestRouter router(api);
        AddBinaryHandlers(router);
        auto res = router.Handle("/version/commit", "", {});
        UNIT_ASSERT(res.Content == ::GetProgramCommitId());
    }

    Y_UNIT_TEST(HandleSVNRevision) {
        TBinaryApi api;
        TRequestRouter router(api);
        AddBinaryHandlers(router);
        auto res = router.Handle("/version/svn/revision", "", {});
        UNIT_ASSERT((res.Content == ToString(::GetProgramSvnRevision())) || (res.Content == ::GetProgramCommitId()));
    }
}
