#pragma once

#include <infra/libs/yp_dns/changelist/proto/changelist.pb.h>

#include <library/cpp/json/json_value.h>

#include <google/protobuf/util/message_differencer.h>

#include <util/generic/algorithm.h>
#include <util/generic/maybe.h>

namespace NYpDns {

using TProtoBaseVersions = google::protobuf::Map<TString, ui64>;

class TBaseVersions : public TProtoBaseVersions {
public:
    TMaybe<ui64> Get(const TString& cluster) const {
        const auto it = find(cluster);
        return it != cend() ? MakeMaybe(it->second) : Nothing();
    }

    TVector<TString> Clusters() const {
        TVector<TString> result;
        result.reserve(size());
        for (const auto& it : *this) {
            result.push_back(it.first);
        }
        Sort(result);
        return result;
    }

    TVector<ui64> VersionsList(const TVector<TString>& clusters) const {
        TVector<ui64> result;
        result.reserve(clusters.size());
        for (const TString& cluster : clusters) {
            result.push_back(at(cluster));
        }
        return result;
    }
};

bool operator<(const TBaseVersions& lhs, const TBaseVersions& rhs);

class TChange : public NProto::TChange {
public:
    TChange();
    TChange(const TChange&);
    TChange(TChange&&);

    TChange(NProto::TChange change);
    TChange(const NJson::TJsonValue& json);

    TChange& operator=(const TChange&);
    TChange& operator=(TChange&&);

    NJson::TJsonValue ToJson() const;

    void FromJson(const NJson::TJsonValue& json);

    bool operator==(const TChange& rhs) const;
};

class TChangelist : public NProto::TChangelist {
public:
    TChangelist();
    TChangelist(const TChangelist&);
    TChangelist(TChangelist&&);
    TChangelist(const NJson::TJsonValue& json);

    TChangelist& operator=(const TChangelist&);
    TChangelist& operator=(TChangelist&&);

    NJson::TJsonValue ToJson() const;

    void FromJson(const NJson::TJsonValue& json);

    void AddChangeEntry(TChange change);

    const TBaseVersions* BaseVersions() const;
    TBaseVersions* MutableBaseVersions();

    bool MatchHash(const TString& hashValue) const;
    bool MatchHashExact(const TString& hashValue) const;

    bool operator==(const TChangelist& rhs) const;
};

} // namespace NYpDns
