#include "labels.h"

#include <library/cpp/digest/murmur/murmur.h>

#include <util/stream/output.h>

template <>
// NOLINTNEXTLINE(readability-identifier-naming)
bool NYpDns::TCiString::to_lower(size_t pos, size_t n) {
    return Transform([](size_t, char c) { return std::tolower(c); }, pos, n);
}

size_t THash<NYpDns::TCiStringBuf>::operator()(NYpDns::TCiStringBuf str) const noexcept {
    TMurmurHash2A<size_t> hash;
    for (size_t i = 0; i < str.size(); ++i) {
        char lower = std::tolower(str[i]);
        hash.Update(&lower, 1);
    }
    return hash.Value();
}

Y_DECLARE_OUT_SPEC(, NYpDns::TLabel, o, label) {
    o.Write(label.data(), label.size());
}
