#include "name.h"

#include "name_ref.h"
#include "view.h"

namespace NYpDns {

TDnsName::TDnsName(TStringBuf name)
    : Labels_(name)
{
}

TDnsName::TDnsName(const char* name)
    : TDnsName(TStringBuf(name))
{
}

TDnsName::TDnsName(TLabels<TLabel> labels)
    : Labels_(std::move(labels.Normalize()))
{
}

bool TDnsName::operator==(const TDnsNameRef& other) const {
    return Labels_ == other.LabelsRef();
}

std::strong_ordering TDnsName::operator<=>(const TDnsNameRef& other) const {
    return Labels_ <=> other.LabelsRef();
}

bool TDnsName::operator==(const TDnsNameView& other) const {
    return Labels_ == other.Labels();
}

std::strong_ordering TDnsName::operator<=>(const TDnsNameView& other) const {
    return Labels_ <=> other.Labels();
}

const TLabels<TLabel>& TDnsName::Labels() const {
    return Labels_;
}

size_t TDnsName::Hash() const {
    return Labels_.Hash();
}

TDnsName& TDnsName::Normalize() {
    Labels_.Normalize();
    return *this;
}

TString TDnsName::ToStringNoDot() const {
    return Labels_.ToNameNoDot();
}

TString TDnsName::ToStringWithDot() const {
    return Labels_.ToNameWithDot();
}

TString TDnsName::ToReversedStringNoDot() const {
    TLabels labels = Labels_;
    return labels.Reverse().ToNameNoDot();
}

bool TDnsName::IsRoot() const {
    return Labels_.empty();
}

} // namespace NYpDns

size_t THash<NYpDns::TDnsName>::operator()(const NYpDns::TDnsName& name) const {
    return name.Hash();
}
