#pragma once

#include "labels.h"

#include <util/generic/strbuf.h>

namespace NYpDns {

class TDnsNameRef;
class TDnsNameView;

class TDnsName {
    friend class TDnsNameRef;
public:
    TDnsName(TStringBuf name);
    TDnsName(const char* name);
    TDnsName(TLabels<TLabel> labels);

    bool operator==(const TDnsName&) const = default;
    std::strong_ordering operator<=>(const TDnsName&) const = default;

    bool operator==(const TDnsNameRef& other) const;
    std::strong_ordering operator<=>(const TDnsNameRef& other) const;

    bool operator==(const TDnsNameView& other) const;
    std::strong_ordering operator<=>(const TDnsNameView& other) const;

    const TLabels<TLabel>& Labels() const;

    size_t Hash() const;

    TDnsName& Normalize();

    TString ToStringNoDot() const;
    TString ToStringWithDot() const;

    // "domain.zone.test.".ToReversedStringNoDot() -> "test.zone.domain"
    TString ToReversedStringNoDot() const;

    bool IsRoot() const;

private:
    TLabels<TLabel> Labels_;
};

} // namespace NYpDns

template <>
struct THash<NYpDns::TDnsName> {
    size_t operator()(const NYpDns::TDnsName& name) const;
};
