#include "name_ref.h"

#include "name.h"
#include "view.h"

namespace NYpDns {

TDnsNameRef::TDnsNameRef(const TDnsName& name)
    : Labels_(MakeConstArrayRef(name.Labels_))
{
}

bool TDnsNameRef::operator==(const TDnsName& other) const {
    return Labels_ == other.Labels();
}

std::strong_ordering TDnsNameRef::operator<=>(const TDnsName& other) const {
    return Labels_ <=> other.Labels();
}

bool TDnsNameRef::operator==(const TDnsNameView& other) const {
    return Labels_ == other.Labels();
}

std::strong_ordering TDnsNameRef::operator<=>(const TDnsNameView& other) const {
    return Labels_ <=> other.Labels();
}

bool TDnsNameRef::IsRefTo(const TDnsName& name) const {
    return Labels_.data() == name.Labels().data() && Labels_.size() == name.Labels().size();
}

TLabelsRef<TLabel> TDnsNameRef::LabelsRef() const {
    return Labels_;
}

bool TDnsNameRef::IsRoot() const {
    return Labels_.empty();
}

bool TDnsNameRef::ChopOff() {
    if (IsRoot()) {
        return false;
    }
    Labels_ = Labels_.Slice(1);
    return true;
}

} // namespace NYpDns
