#pragma once

#include "labels.h"

namespace NYpDns {

class TDnsName;
class TDnsNameView;

class TDnsNameRef {
public:
    TDnsNameRef(const TDnsName& name);
    TDnsNameRef(TDnsName&& name) = delete;

    static constexpr TDnsNameRef Root() noexcept {
        return TDnsNameRef(TLabelsRef<TLabel>());
    }

    bool operator==(const TDnsNameRef&) const = default;
    std::strong_ordering operator<=>(const TDnsNameRef&) const = default;

    bool operator==(const TDnsName&) const;
    std::strong_ordering operator<=>(const TDnsName&) const;

    bool operator==(const TDnsNameView&) const;
    std::strong_ordering operator<=>(const TDnsNameView&) const;

    bool IsRefTo(const TDnsName& name) const;

    TLabelsRef<TLabel> LabelsRef() const;

    bool IsRoot() const;

    bool ChopOff();

private:
    constexpr TDnsNameRef(TLabelsRef<TLabel>&& labelsRef) noexcept
        : Labels_(std::move(labelsRef))
    {
    }

private:
    TLabelsRef<TLabel> Labels_;
};

} // namespace NYpDns
