#include "reverse.h"

#include <util/string/hex.h>

namespace NYpDns {

TString BuildIp6PtrDnsAddress(const TIP6Address& address)
{
    constexpr static TStringBuf DnsIPv6PtrRecordSuffix = "ip6.arpa.";
    constexpr static char DnsIPv6PtrRecordSymbolsDelimeter = '.';
    constexpr static size_t OctetsInIPv6Address = 8;
    constexpr static size_t CharsInOctet = 4;
    constexpr static size_t IPv6PtrDnsRecordDataLength = 73;

    const ui16* octets = address.GetRawWords();
    TString result;
    result.reserve(IPv6PtrDnsRecordDataLength);
    for (size_t octetIndex = 0; octetIndex < OctetsInIPv6Address; ++octetIndex) {
        char octet[CharsInOctet];
        HexEncode(octets + octetIndex, sizeof(octets[0]), octet);
        std::swap(octet[0], octet[1]);
        std::swap(octet[2], octet[3]);
        for (size_t charIndex = 0; charIndex < CharsInOctet; ++charIndex) {
            result += tolower(octet[charIndex]);
            result += DnsIPv6PtrRecordSymbolsDelimeter;
        }
    }
    result += DnsIPv6PtrRecordSuffix;

    return result;
}

} // namespace NYpDns
