#include "view.h"

#include "name.h"
#include "name_ref.h"

namespace NYpDns {

TDnsNameView::TDnsNameView(TStringBuf name)
    : Labels_(name)
{
}

bool TDnsNameView::operator==(const TDnsName& other) const {
    return Labels_ == other.Labels();
}

std::strong_ordering TDnsNameView::operator<=>(const TDnsName& other) const {
    return Labels_ <=> other.Labels();
}

bool TDnsNameView::operator==(const TDnsNameRef& other) const {
    return Labels_ == other.LabelsRef();
}

std::strong_ordering TDnsNameView::operator<=>(const TDnsNameRef& other) const {
    return Labels_ <=> other.LabelsRef();
}

const TLabels<TLabelView>& TDnsNameView::Labels() const {
    return Labels_;
}

bool TDnsNameView::IsRoot() const {
    return Labels_.empty();
}

bool TDnsNameView::IsPartOf(const TDnsNameView& parent) const {
    if (Labels_.size() < parent.Labels_.size()) {
        return false;
    }
    const size_t startIdx = Labels_.size() - parent.Labels_.size();
    for (size_t i = 0; i < parent.Labels_.size(); ++i) {
        if (Labels_[startIdx + i] != parent.Labels_[i]) {
            return false;
        }
    }
    return true;
}

} // namespace NYpDns
