#pragma once

#include "labels.h"

#include <util/generic/strbuf.h>

namespace NYpDns {

class TDnsName;
class TDnsNameRef;

class TDnsNameView {
public:
    TDnsNameView(TStringBuf name);

    bool operator==(const TDnsNameView&) const = default;
    std::strong_ordering operator<=>(const TDnsNameView&) const = default;

    bool operator==(const TDnsName& other) const;
    std::strong_ordering operator<=>(const TDnsName& other) const;

    bool operator==(const TDnsNameRef& other) const;
    std::strong_ordering operator<=>(const TDnsNameRef& other) const;

    const TLabels<TLabelView>& Labels() const;

    bool IsRoot() const;

    bool IsPartOf(const TDnsNameView& parent) const;

private:
    TLabels<TLabelView> Labels_;
};

} // namespace NYpDns
