#pragma once

#include <infra/libs/yp_dns/dynamic_zones/service_feedback.h>

#include <infra/libs/yp_dns/dynamic_zones/protos/configs/client.pb.h>

#include <infra/libs/yp_dns/dynamic_zones/services/protos/api/bridge.pb.h>

#include <infra/libs/yp_dns/zone/zone.h>

#include <infra/libs/logger/logger.h>

#include <mapreduce/yt/interface/fwd.h>

namespace NYpDns::NDynamicZones {

////////////////////////////////////////////////////////////////////////////////

struct TRegistrationOptions {
    bool Enabled = true;
    TString YtProxy;
    TString YtToken;
    NYT::TYPath InstancesPath;
    TString InstanceName;

    TRegistrationOptions() = default;
    TRegistrationOptions(TRegistrationConfig config, TString instanceName, TString ytToken);
};


////////////////////////////////////////////////////////////////////////////////

class IServiceClient {
public:
    virtual ~IServiceClient() = default;

    virtual void StartReportConfiguration() = 0;
    virtual void RegisterInstance(NInfra::TLogFramePtr logFrame) = 0;

    virtual TServiceType ServiceType() const = 0;
    virtual void ReportConfiguration(const TDuration& timeout) const = 0;
};

using IServiceClientPtr = TAtomicSharedPtr<IServiceClient>;

////////////////////////////////////////////////////////////////////////////////

class TBridgeServiceClient : public IServiceClient {
public:
    TBridgeServiceClient(
        TBridgeServiceClientConfig config,
        std::function<NBridgeService::NApi::TReqReportConfiguration()>&& configurationReportRequestGenerator
    );

    ~TBridgeServiceClient() override;

    void StartReportConfiguration() override;

    void RegisterInstance(NInfra::TLogFramePtr logFrame) override;

    TServiceType ServiceType() const override;

    void ReportConfiguration(const TDuration& timeout) const override;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

////////////////////////////////////////////////////////////////////////////////

class TReplicatorServiceClient : public IServiceClient {
public:
    void StartReportConfiguration() override {}
    void RegisterInstance(NInfra::TLogFramePtr /* logFrame */) override {}
    void ReportConfiguration(const TDuration& /* timeout */) const override {}

    TServiceType ServiceType() const override;
};

////////////////////////////////////////////////////////////////////////////////

class TYpDnsExportServiceClient : public IServiceClient {
public:
    void StartReportConfiguration() override {}
    void RegisterInstance(NInfra::TLogFramePtr /* logFrame */) override {}
    void ReportConfiguration(const TDuration& /* timeout */) const override {}

    TServiceType ServiceType() const override;
};

////////////////////////////////////////////////////////////////////////////////

class TClient {
public:
    TClient(TClientConfig config, IServiceClientPtr serviceClient);
    ~TClient();

    TVector<TZone> ListZones() const;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

////////////////////////////////////////////////////////////////////////////////

} // namespace NYpDns::NDynamicZones
