#pragma once

#include "options.h"

#include <infra/libs/yp_dns/dynamic_zones/helpers/yt/events/events_decl.ev.pb.h>

#include <mapreduce/yt/interface/client.h>

namespace NYpDns::NYtHelpers {

////////////////////////////////////////////////////////////////////////////////

NEventlog::TYtLock MakeYtLockEvent(
    NYT::ITransactionPtr transaction,
    const NYT::TYPath& path,
    NYT::ELockMode mode,
    const NYT::TLockOptions& options
);

////////////////////////////////////////////////////////////////////////////////

NEventlog::TYtUpdateWithLock MakeYtUpdateWithLockEvent(
    const NYT::TYPath& lockPath,
    const NYT::TYPath& path,
    const NYT::TNode& data,
    const TUpdateWithLockOptions& options
);

////////////////////////////////////////////////////////////////////////////////

NEventlog::TYtUpdateWithoutLock MakeYtUpdateWithoutLockEvent(
    const NYT::TYPath& path,
    const NYT::TNode& data,
    const TUpdateOptions& options
);

////////////////////////////////////////////////////////////////////////////////

NEventlog::TYtSet MakeYtSetEvent(
    const NYT::TYPath& path,
    const NYT::TNode& data
);

////////////////////////////////////////////////////////////////////////////////

NEventlog::TYtCreate MakeYtCreateEvent(
    const NYT::TYPath& path,
    const NYT::ENodeType& nodeType,
    const NYT::TCreateOptions& options
);

////////////////////////////////////////////////////////////////////////////////

NEventlog::TYtGet MakeYtGetEvent(
    const NYT::TYPath& path,
    const NYT::TGetOptions& options
);

////////////////////////////////////////////////////////////////////////////////

NEventlog::TYtList MakeYtListEvent(
    const NYT::TYPath& path,
    const NYT::TListOptions& options
);

////////////////////////////////////////////////////////////////////////////////

} // namespace NYpDns::NYtHelpers
