#pragma once

#include "options.h"

#include <infra/libs/logger/log_frame.h>

#include <mapreduce/yt/interface/fwd.h>

#include <util/generic/hash_set.h>

namespace NYpDns::NYtHelpers {

////////////////////////////////////////////////////////////////////////////////

class IFilter {
public:
    ~IFilter() = default;

    virtual TVector<TString> AttributesToRequest() const = 0;
    virtual bool Filter(const NYT::TNode& node) const = 0;
};

////////////////////////////////////////////////////////////////////////////////

void CreateCypressNodeIfMissing(
    const NYT::IClientBasePtr ytClient,
    const NYT::TYPath& path,
    NYT::ENodeType nodeType,
    NInfra::TLogFramePtr logFrame
);

void CreateCypressMapNodeIfMissing(
    const NYT::IClientBasePtr ytClient,
    const NYT::TYPath& path,
    NInfra::TLogFramePtr logFrame
);

void CreateCypressDocumentIfMissing(
    const NYT::IClientBasePtr ytClient,
    const NYT::TYPath& path,
    NInfra::TLogFramePtr logFrame
);

////////////////////////////////////////////////////////////////////////////////

void UpdateWithLock(
    const NYT::IClientBasePtr ytClient,
    const NYT::TYPath& lockPath,
    const NYT::TYPath& path,
    const NYT::TNode& data,
    const TUpdateWithLockOptions& options,
    NInfra::TLogFramePtr logFrame
);

void UpdateWithLock(
    const NYT::IClientBasePtr ytClient,
    const NYT::TYPath& lockPath,
    const NYT::TYPath& path,
    const NYT::TNode& data,
    NInfra::TLogFramePtr logFrame
);

void UpdateWithLock(
    const NYT::IClientBasePtr ytClient,
    const NYT::TYPath& path,
    const NYT::TNode& data,
    const TUpdateWithLockOptions& options,
    NInfra::TLogFramePtr logFrame
);

void UpdateWithLock(
    const NYT::IClientBasePtr ytClient,
    const NYT::TYPath& path,
    const NYT::TNode& data,
    NInfra::TLogFramePtr logFrame
);

void UpdateWithoutLock(
    const NYT::IClientBasePtr ytClient,
    const NYT::TYPath& path,
    const NYT::TNode& data,
    const TUpdateOptions& options,
    NInfra::TLogFramePtr logframe
);

void UpdateWithoutLock(
    const NYT::IClientBasePtr ytClient,
    const NYT::TYPath& path,
    const NYT::TNode& data,
    NInfra::TLogFramePtr logframe
);

////////////////////////////////////////////////////////////////////////////////

NYT::TNode TryGetNodeData(
    NYT::IClientBasePtr ytClient,
    const NYT::TYPath& path,
    const NYT::TGetOptions& options,
    NInfra::TLogFramePtr logFrame
);

NYT::TNode TryGetNodeData(
    NYT::IClientBasePtr ytClient,
    const NYT::TYPath& path,
    NInfra::TLogFramePtr logFrame
);

////////////////////////////////////////////////////////////////////////////////

THashSet<TString> ListNodesByFilter(
    NYT::IClientBasePtr ytClient,
    const NYT::TYPath& path,
    const IFilter& filter,
    NInfra::TLogFramePtr logFrame
);

THashSet<TString> ListNodes(
    NYT::IClientBasePtr ytClient,
    const NYT::TYPath& path,
    NInfra::TLogFramePtr logFrame
);

THashSet<TString> ListLockedNodes(
    NYT::IClientBasePtr ytClient,
    const NYT::TYPath& path,
    NInfra::TLogFramePtr logFrame
);

TVector<NYT::TNode> ListNodesData(
    NYT::IClientBasePtr ytClient,
    const NYT::TYPath& path,
    NInfra::TLogFramePtr logFrame
);

////////////////////////////////////////////////////////////////////////////////

bool IsNodeLocked(
    NYT::IClientBasePtr ytClient,
    const NYT::TYPath& path,
    NInfra::TLogFramePtr logFrame
);

////////////////////////////////////////////////////////////////////////////////

} // namespace NYpDns::NYtHelpers
