#pragma once

#include "dns_zones_replica.h"

#include <infra/libs/yp_dns/dynamic_zones/protos/events/events_decl.ev.pb.h>

#include <infra/libs/yp_dns/zone/zone.h>

#include <library/cpp/json/json_value.h>
#include <library/cpp/yson/node/node.h>

namespace NYpDns::NDynamicZones {

////////////////////////////////////////////////////////////////////////////////

NEventlog::TZoneState MakeZoneStateEvent(const NYT::TNode& state);

NEventlog::TZoneState MakeZoneStateEvent(const NJson::TJsonValue& state);

NEventlog::TZoneData MakeZoneDataEvent(const TZone& zoneData, const NJson::TJsonValue& state);

NEventlog::TZoneData MakeZoneDataEvent(const NYT::TNode& zoneData);

NEventlog::TDnsZoneYpObject MakeDnsZoneYpObjectEvent(const TDnsZoneYpObject& ypObject);

////////////////////////////////////////////////////////////////////////////////

NEventlog::TZonesManagerCreateZone MakeZonesManagerCreateZoneEvent(const TZone& zone);

////////////////////////////////////////////////////////////////////////////////

NEventlog::TZonesManagerUpdateZone MakeZonesManagerUpdateZoneEvent(const TZone& zone);

////////////////////////////////////////////////////////////////////////////////

NEventlog::TZonesManagerUpdateZoneData MakeZonesManagerUpdateZoneDataEvent(
    const TZone& zone,
    const NJson::TJsonValue& state
);

NEventlog::TZonesManagerUpdateZoneDataValue MakeZonesManagerUpdateZoneDataValueEvent(const NYT::TNode& data);

////////////////////////////////////////////////////////////////////////////////

NEventlog::TZonesManagerUpdateZoneState MakeZonesManagerUpdateZoneStateEvent(
    const TZoneId& zoneId,
    const NJson::TJsonValue& state
);

////////////////////////////////////////////////////////////////////////////////

NEventlog::TZonesManagerUpdateZoneCurrentState MakeZonesManagerUpdateZoneCurrentStateEvent(
    const TZoneId& zoneId,
    const NJson::TJsonValue& currentState
);

////////////////////////////////////////////////////////////////////////////////

NEventlog::TZonesManagerListZonesResult MakeZonesManagerListZonesResultEvent(
    const TVector<TDnsZoneYpObject>& zones
);

////////////////////////////////////////////////////////////////////////////////

NEventlog::TZonesManagerGetDnsZoneYpObjectSuccess MakeZonesManagerGetDnsZoneYpObjectSuccessEvent(
    TDnsZoneYpObject& zone
);

////////////////////////////////////////////////////////////////////////////////

} // namespace NYpDns::NDynamicZones
