#pragma once

#include <infra/libs/yp_dns/dynamic_zones/services/protos/api/bridge.grpc.pb.h>
#include <infra/libs/yp_dns/dynamic_zones/services/protos/api/bridge.pb.h>
#include <infra/libs/yp_dns/dynamic_zones/services/protos/configs/bridge.pb.h>

#include <infra/libs/yp_dns/dynamic_zones/services/service.h>

#include <infra/libs/yp_dns/zone/zone.h>

#include <infra/libs/service_iface/reply.h>
#include <infra/libs/service_iface/request.h>
#include <infra/libs/service_iface/router.h>

namespace NYpDns::NDynamicZones::NBridgeService {

////////////////////////////////////////////////////////////////////////////////

class IStateServiceApi {
public:
    virtual ~IStateServiceApi() = default;

    virtual void ReportConfiguration(
        NInfra::TRequestPtr<NApi::TReqReportConfiguration>,
        NInfra::TReplyPtr<NApi::TRspReportConfiguration>
    ) = 0;
};

////////////////////////////////////////////////////////////////////////////////

class TStateGrpcService : public NApi::TStateService::Service, private TGrpcCallHandler {
public:
    TStateGrpcService(IStateServiceApi& api)
        : Api_(api)
    {
    }

    grpc::Status ReportConfiguration(
        grpc::ServerContext* ctx,
        const NApi::TReqReportConfiguration* request,
        NApi::TRspReportConfiguration* response
    ) override {
        return Call(ctx, request, response,
            [this](const auto& request, auto& reply) { Api_.ReportConfiguration(request, reply); });
    }

private:
    IStateServiceApi& Api_;
};

////////////////////////////////////////////////////////////////////////////////

class TStateService : public IService, public IStateServiceApi {
public:
    TStateService(
        TStateServiceConfig config,
        TStateServiceCommonOptions commonOptions
    );
    ~TStateService() override;

    void Start(NInfra::TLogFramePtr logFrame) override;
    void Wait() override;
    void ReopenLogs() override;

    void ReportConfiguration(
        NInfra::TRequestPtr<NApi::TReqReportConfiguration>,
        NInfra::TReplyPtr<NApi::TRspReportConfiguration>
    ) override;

    bool AreAllInstancesHasZone(
        const TZoneId& zoneId,
        NInfra::TLogFramePtr logFrame
    ) const;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

////////////////////////////////////////////////////////////////////////////////

} // namespace NYpDns::NDynamicZones::NBridgeService
